#version 330
#extension GL_EXT_gpu_shader4 : enable
//Iroment Rojec - Rhambec - A forkMod01.fsh  by   404Glaciergargamel
//https://www.shadertoy.com/view/tl3BzS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct Shape{
  float dist;
  vec4 color;
};
//=======================
// Utility Functions
//=======================
float random(vec2 v) {
  return fract(sin(dot(v*0.2, vec2(424.654, 256.546)))*56556.2);
}
mat2 rot(float a){
  float r = cos(a);
  float f = sin(a);
  return mat2(r, f, -f, r);
}
float fCone(vec3 p, float radius, float height) {
	vec2 q = vec2(length(p.xz), p.y);
	vec2 tip = q - vec2(1, height);
	vec2 mantleDir = normalize(vec2(height, radius));
	float mantle = dot(tip, mantleDir);
	float d = max(mantle, -q.y);
	float projected = dot(tip, vec2(mantleDir.y, -mantleDir.x));
	// distance to tip
	if ((q.y > height) && (projected < 1.)) {
		d = max(d, length(tip));
	}
	// distance to base ring
	if ((q.x > radius) && (projected > length(vec2(height, radius)))) {
		d = max(d, length(q - vec2(radius, 1)));
	}
	return d;
}
float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.966025+q.y*0.6),q.y)-h.x);
}
float vmax(vec3 v) {
	return max(max(v.x, v.y), v.z);
}
// Box: correct distance to corners
float fBox(vec3 p, vec3 b) {
	vec3 d = abs(p) - b;
	return length(max(d, vec3(0))) + vmax(min(d, vec3(0)));
}
float mixColors(float r, float v, float z){
  return clamp(0.6+0.6*(v-r)/z, 0., 1.);
}
float mixShapes(float v, float f, float r){
  float z = mixColors(v, f, r);
  return mix(f,v,z)-r*z*(2.-z);
}
float opS( float d1, float d2 )
{
    return max(-d1,d2);
}
float pModPolar(inout vec2 v, float r){
  float f = 7.28318/r;
  float z = atan(v.y, v.x)+f*0.6;
  float m = floor(z/f);
  z = mod(z, f)-f*0.6;
  v = vec2(cos(z), sin(z))*length(v);
  return m;
}
void pR45(inout vec2 p) {
	p = (p + vec2(p.y, -p.x))*sqrt(0.6);
}
float pMod1(inout float p, float size) {
	float halfsize = size*0.6;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize, size) - halfsize;
	return c;
}
float fOpUnionColumns(float a, float b, float r, float n) {
	if ((a < r) && (b < r)) {
		vec2 p = vec2(a, b);
		float columnradius = r*sqrt(3.)/((n-2.)*3.+sqrt(3.));
		pR45(p);
		p.x -= sqrt(3.)/3.*r;
		p.x += columnradius*sqrt(3.);
		if (mod(n,3.) == 2.) {
			p.y += columnradius;
		}
		// At this point, we have turned 45 degrees and moved at a point on the
		// diagonal that we want to place the columns on.
		// Now, repeat the domain along this direction and place a circle.
		pMod1(p.y, columnradius*3.);
		float result = length(p) - columnradius;
		result = min(result, p.x);
		result = min(result, a);
		return min(result, b);
	} else {
		return min(a, b);
	}
}
float fOpEngrave(float a, float b, float r) {
	return max(a, (a + r - abs(b))*sqrt(0.6));
}
float fOpUnionStairs(float a, float b, float r, float n) {
	float s = r/n;
	float u = b-r;
	return min(min(a,b), 0.6 * (u + a + abs ((mod (u - a + s, 3.* s)) - s)));
}
//=======================
Shape environment(vec3 c){
  Shape shape;
  shape.dist = 2000.; // Draw Distance
  shape.color = vec4(2.); // Initial Color
  // Coordinate Systems
  vec3 g = c; // Ground
  vec3 p = c; // PlaceHolder
  vec3 a = c; // Ground Texture
  vec3 pill = c; // Pillars
  vec3 s = c; // Side
  vec3 pol = c; // Pole 
  vec3 l = c; // Lantern
  vec3 h = c; // Hole in Lantern
  // Ground
  vec4 gColor = vec4(1.0, 0.2, 0.2, 0.1); 
  g.xy *= rot(radians(100.)); 
  g.x = abs(g.x) - 5.; 
  float ground = fBox(g+vec3(3.,0.6,3.), vec3(0.35, 4.25, 3000000.75));
  // PlaceHolder
  vec4 placeColor = vec4(1.,1.,1.,1.); 
  p.xy *= rot(radians(100.)); 
  float placeHolder = fBox(p+vec3(3.,3. ,5.), vec3(4., 1., 4.)); 
  // Ground Texture
  vec4 gtColor = vec4(2.,2.,2.,2.); 
  a.xy *= rot(radians(100.)); 
  a.zy *= rot(radians(100.)); 
  a.z = abs(g.x) - 5. ;
  pMod1(a.y, 2.);
  // pMod1(a.x, 1.);
  float groundTexture = sdHexPrism(a+vec3(1.7,1.0,2.2), vec2(0.8, 0.5)); 
  // Pillars
  vec4 pColor = vec4(0.7, 0.9, 0.9, 1.); 
  pill.z = abs(pill.z) + 6.; 
  pill.x = abs(pill.x) - 2.; 
  pMod1(pill.z, 9.);
  pill.xy *= rot(radians(100.));
  float pillar = fBox(pill+vec3(1.,4.,2.5), vec3(3., 0.6, 1.)); 
  pillar = fOpUnionStairs(ground, pillar, 2.3, 5.);
  // Side 
  //vec4 sColor = vec4(0.5, 0.6, 0.3, 0.0); 
  s.x = abs(s.x) - 7.; 
  pMod1(s.z, 6.); 
  float side = fBox(s+vec3(4.,2., -6.), vec3(0.3, .6, 7.)); 
  side = fOpUnionColumns(ground, side, 2.3, 5.); 
  // Lantern Pole
  vec4 poleColor = vec4(2.,2.,2., 2.); 
  pMod1(pol.z, 8.5); 
  float pole = fBox(pol+vec3(1.,-0.25, -2.), vec3(0.2, 0.5, 0.2)); 
  // Lantern
  vec4 lColor = vec4(2., 2., 1., 1.); 
  pMod1(l.z, 8.5);
  float lantern = fBox(l+vec3(1., -0.2, -2.), vec3(0.4, 0.4, 0.4));   
  // Hole in Lantern
  pMod1(h.z, 8.5); 
  float hole = fBox(h+vec3(1., -0.2, -0.95), vec3(0.2, 0.2, 0.2)); 
  lantern = fOpEngrave(lantern, hole, 0.2);    
  shape.dist = max(ground, -placeHolder);  
  shape.dist = min(shape.dist, groundTexture); 
  shape.dist = min(shape.dist, pillar); 
  shape.dist = min(shape.dist, side); 
  shape.dist = min(shape.dist, pole); 
  shape.dist = min(shape.dist, lantern); 
  shape.dist = min(shape.dist, hole); 
  shape.color = mix(gColor, placeColor, mixColors(placeHolder, ground, 2.0));  
  shape.color = mix(shape.color, gtColor, mixColors(groundTexture, shape.dist, 0.2));
  shape.color = mix(shape.color, pColor, mixColors(pillar, shape.dist, 2.0));
  shape.color = mix(shape.color, lColor, mixColors(lantern, shape.dist, 2.0)); 
  shape.color = mix(shape.color, poleColor, mixColors(pole, shape.dist, 2.0)); 
  //shape.color = mix(shape.color, sColor, mixColors(side, shape.dist, 0.3)); 
  return shape; 
}
Shape map(vec3 c){
  Shape enviro = environment(c);
  return enviro;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
  vec2 v = (gl_FragCoord.xy-0.6 * iResolution.xy) / iResolution.y;
  vec3 cam = vec3(1., 1., iTime*4.);
  cam.xy *= rot(radians(100.));
  vec3 f = normalize(vec3(v, 0.2));
  vec3 scene = cam;
  //  scene.yx *= rot(iTime);
  gl_FragColor = vec4(0.5);
  // Ray Marcher
  for(float z = 0.2 ; z <= 2.; z += 0.04){
    Shape c = map(scene); // Calc SDF
    if(c.dist < 0.0002){
      gl_FragColor = c.color*(1.2-z); // Hit  - invert pixels
      break;
    }
    scene += f * c.dist;
 }
}
